#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/zeroconf.sh /main/2 2012/05/15 18:58:50 nvira Exp $
#
# zeroconf.sh
#
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      zeroconf.sh - checks the presence of NOZEROCONF in /etc/sysconfig/network
#
#    DESCRIPTION
#      Checks the presence of NOZEROCONF in /etc/sysconfig/network. if NOZEROCONF does not present or
#      it is not set to yes, route for 169.254/16 is generated. this may cause some problems.
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    agorla      05/06/11 - bug#9968337 - check for zeroconf
#    agorla      05/06/11 - Creation
#

GREP=/bin/grep
HOSTNAME=/bin/hostname
host=`${HOSTNAME}`
netfile=/etc/sysconfig/network

catfile=`cat /etc/sysconfig/network`
catorigfile=`cat /etc/sysconfig/network-orig`

pres="<RESULT>SUCC</RESULT><COLLECTED>true</COLLECTED><EXPECTED>true</EXPECTED><TRACE>NOZEROCONF is set to yes in ${netfile} on node ${host}</TRACE>"

fres="<RESULT>VFAIL</RESULT><COLLECTED>false</COLLECTED><EXPECTED>true</EXPECTED><TRACE>NOZEROCONF was not set to yes in ${netfile} on node ${host}. Cat output = $catfile. Cat orig output = $catorigfile</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>10077</ID><MSG_DATA><DATA>${host}</DATA></MSG_DATA></NLS_MSG>"

$GREP -i "NOZEROCONF[ \t]*=[ \t]*yes" $netfile >/dev/null
if [ $? -eq 0 ]
then
  echo ${pres}
else
  echo ${fres}
fi
exit 0
